/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ding.common.core;

import me.ichun.mods.ding.common.Ding;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public abstract class EventHandlerClient {
    public static EventHandlerClient loaderProxy;
    public static boolean postInit;
    private static boolean played;
    private static boolean playWorld;
    private static boolean hasLoadingGui;

    public abstract void hookIntoWorldTick();

    public abstract void hookIntoClientTick();

    public abstract SoundEvent getSoundEvent(ResourceLocation var1);

    public static void postInit() {
        postInit = true;
        if (!played) {
            played = true;
            if (Ding.config.playOnLoad.get().booleanValue()) {
                EventHandlerClient.playSound(Ding.config.name.get(), Ding.config.volume.get().floatValue(), Ding.config.pitch.get().floatValue(), Ding.config.category.get());
            }
        }
        if (Ding.config.playOnWorld.get().booleanValue()) {
            loaderProxy.hookIntoWorldTick();
        }
        if (Ding.config.playOnResourcesReload.get().booleanValue()) {
            loaderProxy.hookIntoClientTick();
        }
    }

    public static void promptToPlayWorld() {
        playWorld = true;
    }

    public static void onWorldTickEnd() {
        if (playWorld && Minecraft.m_91087_().f_91074_ != null && (Minecraft.m_91087_().f_91074_.f_19797_ > 20 || Minecraft.m_91087_().m_91104_())) {
            playWorld = false;
            if (Ding.config.playOnWorld.get().booleanValue()) {
                EventHandlerClient.playSound(Ding.config.nameWorld.get(), Ding.config.volumeWorld.get().floatValue(), Ding.config.pitchWorld.get().floatValue(), Ding.config.categoryWorld.get());
            }
        }
    }

    public static void onClientTickEnd() {
        if (Ding.config.playOnResourcesReload.get().booleanValue()) {
            if (Minecraft.m_91087_().m_91265_() == null && hasLoadingGui) {
                EventHandlerClient.playSound(Ding.config.nameResourcesReload.get(), Ding.config.volumeResourcesReload.get().floatValue(), Ding.config.pitchResourcesReload.get().floatValue(), Ding.config.categoryResourcesReload.get());
            }
            hasLoadingGui = Minecraft.m_91087_().m_91265_() instanceof LoadingOverlay;
        }
    }

    public static void playSound(String name, float volume, float pitch, String categoryName) {
        ResourceLocation rl = new ResourceLocation(name);
        SoundEvent sound = loaderProxy.getSoundEvent(rl);
        SoundSource category = EventHandlerClient.getCategoryByName(categoryName);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(sound == null ? rl : sound.m_11660_(), category, volume, pitch, false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true));
        if (sound == null) {
            Ding.LOGGER.warn("Could not find sound but attempted to play anyway: {}", (Object)rl);
        }
    }

    public static SoundSource getCategoryByName(String name) {
        for (SoundSource value : SoundSource.values()) {
            if (!value.m_12676_().equals(name)) continue;
            return value;
        }
        return SoundSource.MASTER;
    }
}

